#include <bits/stdc++.h>
#define endl '\n'
using namespace std;

const int N = 1e7 + 1;
bool sieve[N] = {};
vector<int> primes;

int firstLowerOrEqual(int p, int N){
    int l = 0, r = primes.size() - 1, m;
    while (l <= r) {
        m = (l + r) / 2;
        if (p * primes[m] <= N &&
            (m + 1 == primes.size() || p * primes[m + 1] > N)) return m;
        else if (p * primes[m] > N) r = m - 1;
        else l = m + 1;
    }
    return -1;
}

void solve(){
    int n; cin >> n;
    int idx = firstLowerOrEqual(2, n), sz1;

    long long ans = n - 1;
    //cout << idx << " " << primes[idx] << endl;
    for (int i = idx + 1; primes[i] <= n; i++){
        //cout << i << " " << primes[i] << endl;
        ans -= n / primes[i];
    }
    cout << ans << endl; return;
}

int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    for (int i = 2; i * i < N; i++){
        if (!sieve[i]){
            for (int j = i * i; j < N; j += i)
                sieve[j] = 1;
        }
    }
    for (int i = 2; i < N; i++)
        if (!sieve[i]) primes.push_back(i);

    int t = 1; cin >> t;
    while (t--) solve();

    return 0;
}